%% check_grbl_read

%% Informationen zur Funktion
% Von Nikolas Arthkamp (11.2021).
% Die Verbindung zur seriellen Schnittstelle muss vor Nutzung dieser Funktion aufgebaut sein.
% Die Funktion liest die serielle Schnittstelle aus, bis eine Antwort erhalten wird
% --> answer enthaelt die ausgelesene Antwort.
% Abbruch der Funktion nach 10000 Durchlaeufen
% --> answer enthaelt "answer_fail".

%% Funktion
%> @brief Die Funktion liest die serielle Schnittstelle aus, bis eine Antwort erhalten wird
%> @param serialport_objekt
%> @param anzahl_zeichen
%> @retval Antwort
function answer = check_grbl_read(serialport_objekt,anzahl_zeichen)

%noetige Variablen einfuehren
check = 1;
counter = 0;
answer_empty = "";
answer = "";

    %Schleife bis eine Antwort erhalten wird
    while check
    
        %serielle Schnittstelle auslesen
        %Syntax: (serialport-Objekt,Anzahl der Zeichen,'Datentyp')
        answer = read(serialport_objekt,anzahl_zeichen,'string');
         
        %pruefen ob die Antwort leer ist und Bedingung fuer while-Schleife setzen
        if answer == answer_empty
            check = 1;
        else
            check = 0;
        end 
   
        %Abbruch nach 10000 durchlaeufen
        if counter >= 10000
            %Antwort fuer weitere Nutzung setzen
            answer = "Keine Antwort erhalten!";
            break
        end
   
        %Kontrollzaehler erhoehen
        counter = counter + 1;
   
    end
    
%Entfernen der Terminatoren der grbl-Antwort  
answer = regexprep(answer,'\r\n','');

end